# $Id: dot.profile,v 1.26 2021/11/20 23:14:57 nanons Exp $
#
# Login shell initialization file for sh(1) and ksh(1)
#
# This file is sourced after login(1) and when an xterm(1) or tmux(1)
# window is opened.  It is not a suitable place for commands that should
# be ran only once at startup, use "@reboot" in crontab(5) instead.
#
# The TERM environment variable should not be set here because it
# conflicts with terminal emulators.  See xenocara/resources/xterm for
# changing it in xterm(1), home/dot.tmux.conf for changing it in
# tmux(1), and the ttys(5) man page for changing it in the console.
# To enable colors in the console on amd64 or i386, set TERM to "pccon0"
# but note you may need to ssh(1) to older machines from within tmux(1).

# Set shell startup file (see shell/dot.kshrc)
export ENV=~/.kshrc

# Set search path for programs
export PATH=$PATH:/usr/games:~/bin

# Set system pager (defaults to more(1) for most programs)
export PAGER=/usr/bin/less

# Set system editor (defaults to vi(1) for most programs)
export EDITOR=/usr/bin/vi

# Set editor for the "fc" command:
#	$ man -Otag=fc ksh
export FCEDIT=$EDITOR

# Start less(1) with some useful default options
# -i enables case insensitive searches
# -M shows more verbose prompt messages
# -R enables colors (enabled by default, but not if the LESS variable is set)
export LESS=-iMR

# Disable dangerous functionality in less(1) using pledge(2):
#	$ man -Otag=SECURITY less
export LESSSECURE=1

# Route ftp(1) traffic through Tor, and by extension pkg_add(1),
# pkg_info(1), ports(7) fetching, syspatch(8) and sysupgrade(8)
# fw_update(1) doesn't work because Tor only accepts HTTPS connections
# Requires appending "HTTPTunnelPort 8080" to /etc/tor/torrc
# Unnecessary if using a transparent proxy (see pf/tor-transparent.conf)
export http_proxy=http://127.0.0.1:8080/
