package dareka.processor.impl;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import dareka.Main;
import dareka.processor.HttpHeader;
import dareka.processor.HttpRequestHeader;
import dareka.processor.Processor;
import dareka.processor.Resource;
import dareka.processor.StringResource;

// [nl] localフォルダ・wrapper関係のアドレス処理
public class LocalDirProcessor implements Processor {
    // 任意のMethodにマッチ
    private static final String[] SUPPORTED_METHODS = new String[] { null };
    private static final Pattern LOCAL_DIR_PATTERN = Pattern
        .compile("^https?://[^/]+\\.nicovideo\\.jp/((?:flv|nico)player\\.swf|flvplayer_wrapper\\.swf|flv_booster\\.swf|local(/?|/[-_\\w./]+|\\w+\\.\\w+))(\\?.*)?$");

    @Override
    public String[] getSupportedMethods() {
        return SUPPORTED_METHODS;
    }

    @Override
    public Pattern getSupportedURLAsPattern() {
        return LOCAL_DIR_PATTERN;
    }

    @Override
    public String getSupportedURLAsString() {
        return null;
    }

    @Override
    public Resource onRequest(HttpRequestHeader requestHeader, Socket browser)
            throws IOException {
        // GET以外も捕まえてサーバに存在しないURLへのリクエストが飛ぶのを防ぐ
        if (!HttpHeader.GET.equals(requestHeader.getMethod())) {
            return StringResource.getMethodNotAllowed();
        }

        String uri = requestHeader.getURI();
        Matcher m = LOCAL_DIR_PATTERN.matcher(uri);
        if (m.find()) {
            File file = null;
            String path = m.group(1);
            if (path.equals("flvplayer_wrapper.swf")) {
// 常にlocalから返すように変更(swfConvert04)
                file = new File("local", path);
            }
            //ローカルにnicoplayer.swfがある時はそれを利用する(夏.07)
            else if (path.equals("flv_booster.swf") || path.equals("nicoplayer.swf")) {
                // booster
                file = new File("local", path);
            }
            else if (m.group(2) != null && !m.group(2).equals("")
                                        && !m.group(2).equals("/")) {
                file = new File("local", m.group(2));
                if (m.group(2).equals("/list.js") && !file.exists())
                    file = new File("local", "list.js.default");
            }
            return Main.getRewriterProcessor().localRewriter(
                    uri, file, requestHeader);
        }
        return StringResource.getNotFound();
    }

    /**
     * LocalDirProcessorがサポートする(=処理する)URLか？
     * @param url 判定するURL文字列
     * @return サポートするURLならtrue
     */
    public static boolean isSupportedURL(String url) {
        return LOCAL_DIR_PATTERN.matcher(url).matches();
    }

}
